	;
	; Viboritas (little snakes)
	;
	; by Oscar Toledo G.
	; (c) Copyright Oscar Toledo G. 1990-2024
	; https://nanochess.org/
	;
	; Creation date: Oct/1990. I was 11 years old.
	; Revision date: Jan/31/2024. Disassembled.
	; Revision date: Feb/01/2024. Ported to MSX/Colecovision.
	;

COLECO: EQU 1   ; Define this to 0 for MSX, 1 for Colecovision

RAM_BASE:	EQU $E000-$7000*COLECO
VDP:		EQU $98+$26*COLECO

PSG:	EQU $FF	; Colecovision

PSG_ADDR:	EQU $A0	; MSX
PSG_DATA:	EQU $A1	; MSX

KEYSEL:	EQU $80
JOYSEL:	EQU $C0
JOY1:	EQU $FC
JOY2:	EQU $FF

    if COLECO
        fname "viboritas_cv.ROM"

	org $8000,$9fff

	dw $aa55	; No BIOS title screen
	dw 0
	dw 0
	dw 0
	dw 0
	dw START

	jp 0		; RST $08
	jp 0		; RST $10
	jp 0		; RST $18
	jp 0		; RST $20
	jp 0		; RST $28
	jp 0		; RST $30
	jp 0		; RST $38

	jp 0		; No NMI handler

    else
        fname "viboritas_msx.ROM"

	org $4000,$5fff

	dw $4241
	dw START
	dw 0
	dw 0
	dw 0
	dw 0
	dw 0
	dw 0

WRTPSG: equ $0093
SNSMAT:	equ $0141

    endif

WRTVDP:
	ld a,b
	out (VDP+1),a
	ld a,c
	or $80
	out (VDP+1),a
	ret

SETWRT:
	ld a,l
	out (VDP+1),a
	ld a,h
	or $40
	out (VDP+1),a
	ret

WRTVRM:
	push af
	call SETWRT
	pop af
	out (VDP),a
	ret

FILVRM:
	push af
	call SETWRT
.1:	pop af
	out (VDP),a
	push af
	dec bc
	ld a,b
	or c
	jp nz,.1
	pop af
	ret

	; Setup VDP before game
setup_vdp:
	LD BC,$0200
	CALL WRTVDP
	LD BC,$C201	; No interrupts
	CALL WRTVDP
	LD BC,$0F02	; $3C00 for pattern table
	CALL WRTVDP
	LD BC,$FF03	; $2000 for color table
	CALL WRTVDP
	LD BC,$0304	; $0000 for bitmap table
	CALL WRTVDP
	LD BC,$3605	; $1b00 for sprite attribute table
	CALL WRTVDP
	LD BC,$0706	; $3800 for sprites bitmaps
	CALL WRTVDP
	LD BC,$0407	; Blue border
	CALL WRTVDP
    IF COLECO
	LD HL,($006C)   ; MSX BIOS chars
	LD DE,-128
	ADD HL,DE
    ELSE
	LD HL,($0004)   ; MSX BIOS chars
	INC H
    ENDIF
        PUSH HL
        LD DE,$0100
        LD BC,$0300
        CALL LDIRVM
        POP HL
        PUSH HL
        LD DE,$0900
        LD BC,$0300
        CALL LDIRVM
        POP HL
        LD DE,$1100
        LD BC,$0300
        CALL LDIRVM

        LD HL,$2000
        LD BC,$1800
        LD A,$F4
        CALL FILVRM
	RET

LDIRVM:
        EX DE,HL
.1:     LD A,(DE)
        CALL WRTVRM
        INC DE
        INC HL
        DEC BC
        LD A,B
        OR C
        JR NZ,.1
        RET

GTTRIG:
    if COLECO
        out (KEYSEL),a
        ex (sp),hl
        ex (sp),hl
        in a,(JOY1)
        ld c,a
        in a,(JOY2)
        and c
        ld c,a
	out (JOYSEL),a
	ex (sp),hl
	ex (sp),hl
	in a,(JOY1)
        and c
        ld c,a
	in a,(JOY2)
	and c
	rlca
	rlca
	ccf
	ld a,0
	sbc a,a
	ret
    else
	xor a
	call $00d8
	or a
	ret nz
	ld a,1
	call $00d8
	or a
	ret nz
        ld a,2
        call $00d8
        or a
        ret nz
        ld a,3
        call $00d8
        or a
        ret nz
        ld a,4
        call $00d8
        ret
    endif

	;
	; Gets the joystick direction
	; 0 - No movement
	; 1 - Up
	; 2 - Up + right
	; 3 - Right
	; 4 - Right + down
	; 5 - Down
	; 6 - Down + left
	; 7 - Left
	; 8 - Left + Up
	;
GTSTCK:
    if COLECO
        out (JOYSEL),a
	ex (sp),hl
	ex (sp),hl
        in a,(JOY1)
	ld b,a
	in a,(JOY2)
	and b
        and $0f
        ld c,a
        ld b,0
        ld hl,joy_map
        add hl,bc
        ld a,(hl)
        ret

joy_map:
        db 0,0,0,6,0,0,8,7,0,4,0,5,2,3,1,0

    else
	xor a
	call $00d5
	or a
	ret nz
	ld a,1
	call $00d5
	or a
	ret nz
	ld a,2
	jp $00d5
    endif

	; ROM routines I forgot

	; Clean screen
L04CC:	; $04cc
	LD HL,$3C00
	LD BC,$0300
	XOR A
	JP FILVRM

	; Select address or register in VDP
L0100:
	LD A,L
	OUT (VDP+1),A
	LD A,H
	ADD A,$40
	OUT (VDP+1),A
	RET


	; Copy string to VDP
L0169:	; $0169
	EX (SP),HL

.0:	LD A,(HL)
	INC HL
	OR A
	JR Z,.1
	PUSH AF
	POP AF
	OUT (VDP),A
	JR .0

.1:	EX (SP),HL
	RET

	;
	; Start of the game
	;
START:		; 8000
	DI			; We don't need interruptions.
	LD SP,L87F0
   if COLECO
	CALL $1FD6		; Turn off sound.
   endif
	CALL setup_vdp		; Not in original but needed to setup VDP.

	ld hl,$7513
	ld (L8780),hl
	ld hl,$983f
	ld (L8782),hl
	ld hl,$c9bf
	ld (L8784),hl

L8000:      	CALL L04CC	; Clear the screen.
            	CALL L801B	; Setup graphics.
            	CALL L81BA	; Game initialization.
	;
	; Start level.
	;
L8009:      	CALL L8217	; Draw the current level.
	;
	; Main game loop.
	;
L800C:      	CALL L8324	; Move the player.
            	CALL L8504	; Move the enemies.
            	JR NC,L800C	; Jump if game continues (always jumps!)
L8014:          LD HL,L87FC	; Current level number.
            	INC (HL)	; Increases it.
            	JP L8009	; Repeat the loop.

	;
	; Setup graphics (bitmaps, color, and sprites).
	;
L801B:      	LD HL,$0400	; Character $80.
                LD DE,L806A	; Bitmaps definitions.
            	LD BC,$00C8	; Bitmaps size.
            	CALL L805D	; Copy to VRAM.
            	LD HL,$2400	; Character $80 color (first third).
                LD DE,L8112	; Color data.
            	LD BC,$001B	; Size.
            	CALL L8148	; Decompress to VRAM.
            	LD HL,$2C00	; Character $80 color (second third).
                LD DE,L8112	; Color data.
            	LD BC,$001B	; Size.
            	CALL L8148	; Decompress to VRAM.
            	LD HL,$3400	; Character $80 color (final third).
                LD DE,L8112	; Color data.
            	LD BC,$001B	; Size.
            	CALL L8148	; Decompress to VRAM.
            	LD HL,$3800	; Sprite bitmaps.
                LD DE,L8404	; Sprite data.
            	LD BC,$0100	; Load 8 sprites (32 bytes each one).
            	CALL L805D	; Copy to VRAM.
            	LD HL,$4400	; VDP Register 4 = $00
            	JP L83FB

	;
	; Copy a memory area to VRAM.
	;
L805D:      	CALL L0100	; Select VRAM address.
L8060:      	LD A,(DE)	; Read byte.
            	OUT (VDP),A	; Send to VRAM.
            	INC DE		; Next byte.
            	DEC BC		; Decrease counter.
            	LD A,B
            	OR C
            	JR NZ,L8060	; Repeat if non-zero.
            	RET		; Return.

	;
	; Background bitmaps.
	;
L806A:          db $FF,$FF,$FF,$FF  ; $806A
            	db $FF,$FF,$FF,$FF  ; $806E
            	db $E7,$E7,$E7,$E7  ; $8072
            	db $E7,$E7,$E7,$E7  ; $8076
            	db $FF,$FF,$00,$FF  ; $807A
            	db $FF,$00,$FF,$FF  ; $807E
            	db $42,$42,$7E,$42  ; $8082
            	db $42,$7E,$42,$42  ; $8086
            	db $FE,$82,$BA,$AA  ; $808A
            	db $BA,$82,$FE,$00  ; $808E
            	db $BA,$BA,$BA,$BA  ; $8092
            	db $BA,$BA,$BA,$BA  ; $8096
            	db $EE,$00,$FF,$FF  ; $809A
            	db $FF,$00,$00,$00  ; $809E
            	db $42,$42,$7E,$42  ; $80A2
            	db $42,$7E,$42,$42  ; $80A6
            	db $EF,$EF,$EF,$00  ; $80AA
            	db $FE,$FE,$FE,$00  ; $80AE
            	db $7E,$7E,$7E,$00  ; $80B2
            	db $6E,$6E,$6E,$00  ; $80B6
            	db $00,$FF,$FF,$AA  ; $80BA
            	db $44,$00,$00,$00  ; $80BE
            	db $42,$42,$7E,$42  ; $80C2
            	db $42,$7E,$42,$42  ; $80C6
            	db $EE,$EE,$EE,$00  ; $80CA
            	db $EE,$EE,$EE,$00  ; $80CE
            	db $40,$30,$0C,$03  ; $80D2
            	db $0C,$30,$40,$40  ; $80D6
            	db $00,$FF,$00,$AA  ; $80DA
            	db $55,$00,$FF,$00  ; $80DE
            	db $81,$81,$C3,$BD  ; $80E2
            	db $81,$81,$C3,$BD  ; $80E6
            	db $81,$58,$37,$47  ; $80EA
            	db $39,$27,$49,$27  ; $80EE
            	db $47,$49,$27,$40  ; $80F2
            	db $28,$15,$12,$27  ; $80F6
            	db $00,$FE,$FE,$00  ; $80FA
            	db $EF,$EF,$00,$00  ; $80FE
            	db $0C,$0C,$18,$18  ; $8102
            	db $30,$30,$18,$18  ; $8106
            	db $54,$FE,$54,$FE  ; $810A
            	db $54,$FE,$54,$00  ; $810E

	;
	; Background colors.
	;
L8112:          db $08,$cc,$08,$21  ; $8112
            	db $08,$A1,$08,$51  ; $8116
            	db $08,$54,$08,$51  ; $811A
            	db $01,$F1,$01,$11  ; $811E
            	db $03,$E1,$03,$11  ; $8122
            	db $08,$51,$08,$68  ; $8126
            	db $08,$81,$10,$51  ; $812A
            	db $08,$61,$08,$A1  ; $812E
            	db $03,$F1,$02,$51  ; $8132
            	db $03,$F1,$08,$E1  ; $8136
            	db $08,$86,$08,$2c  ; $813A
            	db $01,$11,$06,$6E  ; $813E
            	db $01,$11,$08,$c1  ; $8142
            	db $08,$F1  ; $8146

	;
	; Decompress colors.
	;
L8148:      	CALL L0100	; Set VRAM address.
            	LD B,C		; Copy count into B.
L814C:      	PUSH BC
            	LD A,(DE)	; Read byte count.
            	LD B,A		; Save into B.
            	INC DE		; Go to next byte.
            	LD A,(DE)	; Read byte to replicate.
            	INC DE		; Go to next byte.
L8152:      	OUT (VDP),A	; Write to VRAM.
            	NOP
            	DJNZ L8152	; Repeat byte.
            	POP BC
            	DJNZ L814C	; Continue decompressing.
            	RET

	;
	; Music player.
	;
L815B:          LD HL,L87FA
            	INC (HL)	; Increase ticks.
            	LD A,(HL)
            	CP $08		; 8 ticks?
            	JR NZ,L8194	; No, jump.
            	LD (HL),$00	; Reset tick counter.
            	DEC HL		; Now HL points to L87F9.
            	INC (HL)	; Increment song note index.
            	LD A,(HL)
            	CP $30		; 48 notes?
            	JR NZ,L816F	; No, jump.
            	LD (HL),$01	; Reset to start.
L816F:      	LD A,(HL)
            	ADD A,255 AND (L8744-1)
            	LD L,A		; Index into song notes.
            	LD H,(L8744-1)>>8
            	CALL L8197	; Get pointer to frequency to play.
	if COLECO
		LD A,(HL)
		INC HL
		LD H,(HL)
		LD L,A
		AND $0F
		OR $80
		OUT (PSG),A
		SRL H
		RR L
		SRL H
		RR L
		SRL H
		RR L
		SRL H
		RR L
		LD A,L
		OUT (PSG),A
		LD A,$93
		OUT (PSG),A
	else
		LD E,(HL)
		LD A,0
		CALL WRTPSG
		INC HL
		LD E,(HL)
		LD A,1
		CALL WRTPSG
		LD E,$0A
		LD A,$08
		CALL WRTPSG
	endif
L8194:      	JP L8398

L8197:      	LD A,(HL)	; Get note number.
            	ADD A,A		; Index into table.
            	ADD A,255 AND (L81A2-2)
            	LD L,A
            	LD H,(L81A2-2)>>8
            	RET

	;
	; Note table.
	;
L81A2:          dw $01ac
		dw $0153
		dw $011d
		dw $00fe
		dw $00f0
		dw $0140
		dw $00d6
		dw $00be
		dw $00b4
		dw $00aa
		dw $00a0
		dw $00e2

	;
	; Game initialization.
	;
L81BA:      	XOR A
            	LD (L87F3),A	; X-coordinate of enemy 1.
            	LD (L87F4),A	; X-direction of enemy 1.
            	LD (L87F7),A	; X-coordinate of enemy 3.
            	LD (L87F8),A	; X-direction of enemy 3.
            	LD A,$F0	; X-coordinate of enemy 2.
            	LD (L87F5),A
            	LD A,$01	; X-direction of enemy 2.
            	LD (L87F6),A
            	LD A,$0F	; Y-coordinate of player.
            	LD (L8786),A
            	LD A,$00	; X-coordinate of player.
            	LD (L8787),A
            	LD HL,$0000	; Music player reset.
            	LD (L87F9),HL
            	LD A,$02	; Number of lives.
            	LD (L87FB),A
            	CALL L04CC	; Clear the screen.
            	LD HL,$3EE9	; VRAM position for copyright message.
            	CALL L0100
            	CALL L0169
                db "(C) OTEK 1990",0
                LD HL,$3EAC	; VRAM position for lives indicator.
            	CALL L0100
            	CALL L0169
                db "VIDAS:0",0
            	LD A,$01	; Start level number.
            	JP L82A5

            	db $FF  ; $8216

	;
	; Draw the current level.
	;
L8217:      	LD A,(L87FC)	; Get the current level.
            	ADD A,A		; x2.
            	ADD A,A		; x4.
            	ADD A,$7C	; Add the graphic character number.
            	LD (L87FD),A	; Save it for reference.
            	LD HL,$3C00	; Point to the start of the VRAM screen.
            	CALL L0100
            	LD B,$A0	; 160 times.
L8229:      	PUSH BC
            	LD B,$03	; 3 times.
L822C:      	LD A,(L87FD)	; Wall character.
            	OUT (VDP),A	; Write to VRAM.
            	INC HL
            	DJNZ L822C
            	LD A,(L87FD)
	      	INC A		; Column character.
            	OUT (VDP),A	; Write to VRAM.
            	INC HL
            	POP BC
            	DJNZ L8229
            	LD HL,$3C80	; Point to first floor on the screen.
            	LD B,$04	; Going to draw 4 floors.
L8243:      	PUSH BC
            	PUSH HL
            	CALL L0100	; Set VRAM address to write.
            	LD B,$20	; Each floor is 32 characters wide.
L824A:      	LD A,(L87FD)
            	ADD A,$02	; Floor character.
            	OUT (VDP),A	; Write to VRAM.
            	INC HL
            	DJNZ L824A
            	POP HL
            	LD BC,$00A0	; Go to next floor position.
            	ADD HL,BC
            	POP BC
            	DJNZ L8243
            	LD HL,$4701	; Set border color as black.
            	CALL L0100
            	LD HL,$2000	; Reset charset colors (top)
            	CALL L8277
            	LD HL,$2800	; Reset charset colors (middle)
            	CALL L8277
            	LD HL,$3000	; Reset charset colors (bottom)
            	CALL L8277
            	JP L8288	; Patch.

L8277:      	LD A,H		; Get target address.
            	ADD A,$04	; Add $0400, it is the limit.
            	LD B,A
            	CALL L0100
L827E:      	LD A,$F1	; White on black.
            	OUT (VDP),A	; Write to VRAM.
            	INC HL
            	LD A,H
            	CP B		; Reached the limit?
            	JR NZ,L827E	; No, continue.
            	RET

L8288:      	LD HL,$3E5E	; Bottom-right of the level.
            	CALL L0100	; Set VRAM address.
            	LD A,$94	; "Drain" character.
            	OUT (VDP),A
            	LD HL,$3C80	; Floor 1.
            	CALL L82B0	; Draw ladders.
            	LD HL,$3D20	; Floor 2.
            	CALL L82B0	; Draw ladders.
            	LD HL,$3DC0	; Floor 3.
            	CALL L82B0	; Draw ladders.
            	RET

L82A5:      	LD (L87FC),A	; Initialize level number.
            	XOR A
            	LD (L87FE),A
            	LD (L87FF),A
            	RET

	;
	; Draw the ladders for the level.
	;
L82B0:      	LD A,(L87FC)	; Get current level number.
            	LD B,A
            	LD A,$06	; number of ladders = 6 - level.
            	SUB B
            	LD B,A
L82B8:      	PUSH BC
            	PUSH HL
            	NOP
            	LD D,$00
            	NOP
            	CALL L82CB	; Generate a random number 0-31.
            	LD E,A		; Use it as offset.
            	ADD HL,DE
            	CALL L830F	; Draw ladder.
            	POP HL
            	POP BC
            	DJNZ L82B8
            	RET

	;
	; Generates a random number between 0 and 31.
	;
L82CB:      	PUSH BC
            	PUSH DE
            	PUSH HL
            	LD HL,(L8780)
            	LD DE,(L8782)
            	LD BC,(L8784)
            	ADD HL,HL
            	ADD HL,HL
            	ADD HL,BC
            	ADD HL,DE
            	LD (L8780),HL
            	ADD HL,DE
            	ADD HL,DE
            	ADD HL,BC
            	ADD HL,BC
            	ADD HL,BC
            	ADD HL,HL
            	ADD HL,HL
            	ADD HL,HL
            	ADD HL,HL
            	ADD HL,DE
            	ADD HL,BC
            	LD (L8782),HL
            	ADD HL,DE
            	ADD HL,DE
            	ADD HL,BC
            	ADD HL,HL
            	ADD HL,DE
            	ADD HL,BC
            	ADD HL,BC
            	ADD HL,BC
            	ADD HL,BC
            	LD (L8784),HL
            	LD HL,(L8780)
            	LD DE,(L8782)
            	LD BC,(L8784)
            	ADD HL,DE
            	ADD HL,BC
            	LD A,H
            	ADD A,L
            	AND $1F
            	POP HL
            	POP DE
            	POP BC
            	RET

	;
	; Draw a ladder at the VRAM address pointed by HL.
	;
L830F:      	LD B,$05	; Ladders are 5 rows high.
            	LD A,(L87FD)
            	ADD A,$03	; Ladder character.
L8316:      	PUSH AF
            	CALL L0100	; Set VRAM address.
            	POP AF
            	OUT (VDP),A	; Draw ladder.
            	LD DE,$0020
            	ADD HL,DE	; Go to next row.
            	DJNZ L8316
            	RET

	;
	; Position the game sprites.
	; 
L8324:      	LD HL,$1B00
            	LD A,(L8786)	; Y-coordinate of the player.
            	CALL L8390	; Write to VRAM.
            	INC HL
            	LD A,(L8787)	; X-coordinate of the player.
            	CALL L8390	; Write to VRAM.
            	INC HL
            	LD A,(L87FE)	; Sprite frame of the player.
            	CALL L8390	; Write to VRAM.
            	INC HL
            	LD A,$0F	; Color of the player.
            	CALL L8390	; Write to VRAM.
            	INC HL
            	LD A,$38	; Y-coordinate of enemy 1.
            	CALL L8390
            	INC HL
                LD DE,L87F3	; Data of enemy 1.
            	CALL L86C5	; Update.
            	LD A,$0E	; Gray color.
            	CALL L8390
            	INC HL
            	LD A,$60	; Y-coordinate of enemy 2.
            	CALL L8390
            	INC HL
                LD DE,L87F5	; Data of enemy 2.
            	CALL L86C5	; Update.
            	LD A,$0E	; Gray color.
            	CALL L8390
            	INC HL
            	LD A,$88	; Y-coordinate of enemy 3.
            	CALL L8390
            	INC HL
                LD DE,L87F7	; Data of enemy 3.
            	CALL L86C5	; Update.
            	LD A,$0E	; Gray color.
            	CALL L8390
            	JP L815B	; Go to the music player.

	;
	; Sound effect for player dying.
	;
L837A:
	if COLECO
		ld a,$8E
		out (PSG),a
		ld a,$2a
		out (PSG),a
	else
		ld e,$ae
		ld a,$00
		call WRTPSG
		ld e,$06
		ld a,$01
		call WRTPSG
	endif
            	JP L8774	; Jump to delay.

            	db $FF,$FF,$FF,$FF  ; $838C

	;
	; Subroutine to write VRAM with a single byte.
	;
L8390:      	PUSH AF
            	CALL L0100
            	POP AF
            	OUT (VDP),A
            	RET

	;
	; Handle joystick.
	;
L8398:      	CALL GTSTCK
            	CP $07		; Going left?
            	JP Z,L83DD
            	CP $03		; Going right?
            	JP Z,L83B5
            	CP $01		; Going up?
            	JP Z,L85B5
            	CP $05		; Going down?
            	JP Z,L8567
		CALL GTTRIG
            	CP $ff		; Button pressed?
            	JP Z,L8684
            	RET

	;
	; Move the player to the right.
	;
L83B5:          LD HL,L8787	; X-coordinate for player.
            	INC (HL)	; +1.
            	INC (HL)	; +2.
            	NOP
            	LD A,(HL)
            	CP $00		; Reached limit?
            	JR NZ,L83C2	; No, jump.
            	LD (HL),$FE	; Limit it.
L83C2:      	LD A,(L87FE)	; Sprite frame for player.
            	CP $04		; Is it $04?
            	JR NZ,L83CD	; No, jump.
            	LD A,$00	; Yes, set to $00.
            	JR L83CF

L83CD:      	LD A,$04	; No, set to $04.
L83CF:      	LD (L87FE),A	; Update sprite frame.
            	RET

	;
	; Game delay.
	;
L83D3:      	CALL L861E
L83D6:      	DEC BC
            	LD A,B
            	OR C
            	JR NZ,L83D6
            	AND A
            	RET

	;
	; Move the player to the left.
	;
L83DD:          LD HL,L8787	; X-coordinate for the player.
            	DEC (HL)	; -1.
            	DEC (HL)	; -2.
            	NOP
            	LD A,(HL)	
            	CP $FE		; Reached the limit?
            	JR NZ,L83EA	; No, jump.
            	LD (HL),$00	; Limit it.
L83EA:      	LD A,(L87FE)	; Get the sprite frame.
            	CP $0C		; Is it $0c?
            	JR NZ,L83F5	; No, jump.
            	LD A,$08	; Yes, now it is $08.
            	JR L83F7

L83F5:      	LD A,$0C	; No, now it is $0c.
L83F7:      	LD (L87FE),A	; Set the sprite frame.
            	RET

L83FB:      	CALL L0100
            	LD HL,$41C2
            	JP L0100

	;
	; Sprites for the player and half of the snakes.
	;
L8404:
	; $00 - Player going right (frame 1).
	DB $00,$01,$05,$03,$07,$03,$07,$1e
	DB $37,$67,$77,$74,$03,$0e,$0e,$0f
	DB $00,$50,$f0,$f0,$d0,$70,$10,$e0
	DB $00,$b8,$b8,$00,$c0,$f8,$7c,$00
	; $04 - Player going right (frame 2).
	DB $00,$02,$01,$03,$01,$03,$03,$07
	DB $07,$06,$06,$07,$03,$03,$03,$03
	DB $a8,$f8,$f8,$e8,$b8,$88,$70,$80
	DB $c0,$e0,$e0,$00,$c0,$00,$c0,$e0
	; $08 - Player going left (frame 1).
	DB $00,$0a,$0f,$0f,$0b,$0e,$08,$07
	DB $00,$1d,$1d,$00,$03,$07,$1e,$3e
	DB $00,$80,$a0,$c0,$e0,$c0,$e0,$78
	DB $ec,$e6,$ee,$2e,$c0,$70,$70,$f0
	; $0c - Player going right (frame 2).
	DB $15,$1f,$1f,$17,$1d,$11,$0e,$01
	DB $03,$07,$07,$00,$03,$00,$03,$07
	DB $00,$40,$80,$c0,$80,$c0,$c0,$e0
	DB $e0,$60,$60,$e0,$c0,$c0,$c0,$c0
	; $10 - Player using ladder (frame 1).
	DB $0a,$07,$0f,$0f,$07,$07,$03,$0c
	DB $1b,$70,$73,$02,$06,$06,$1e,$3e
	DB $a0,$c0,$e0,$e0,$ce,$ce,$98,$70
	DB $c0,$00,$c0,$60,$38,$3c,$00,$00
	; $14 - Player using ladder (frame 2).
	DB $05,$03,$07,$07,$73,$73,$19,$0e
	DB $03,$00,$03,$06,$1c,$3c,$00,$00
	DB $50,$e0,$f0,$f0,$e0,$e0,$c0,$30
	DB $d8,$0e,$ce,$40,$60,$60,$78,$7c
	; $18 - Snake going left (frame 1).
	DB $1b,$2d,$2d,$36,$1f,$7d,$9b,$03
	DB $0f,$1f,$3e,$3c,$3c,$3f,$1f,$0f
	DB $00,$00,$00,$00,$00,$80,$80,$82
	DB $02,$06,$06,$0e,$cc,$ec,$fc,$38
	; $1c - Snake going right (frame 2).
	DB $00,$0d,$16,$16,$1b,$0f,$1e,$5d
	DB $61,$0f,$1f,$1e,$1e,$1f,$0f,$07
	DB $00,$80,$80,$80,$00,$80,$c0,$c0
	DB $c0,$84,$0c,$cc,$d8,$f8,$b8,$30

L8504:      	CALL L850A
            	JP L83D3

	;
	; Move enemies.
	;
L850A:          LD HL,L87F3		; Pointer to enemy 1.
            	CALL L8517
            	LD L,255 AND L87F5	; Pointer to enemy 2.
            	CALL L8517
            	LD L,255 AND L87F7	; Pointer to enemy 3.
L8517:      	INC HL
            	LD A,(HL)	; Get direction.
            	OR A		; Going right?
            	LD B,$03	; +3 pixels.
            	JR Z,L8520	; Yes, jump.
            	LD B,$FD	; -3 pixels.
L8520:      	DEC HL
            	LD A,(HL)	; Get X-coordinate.
            	ADD A,B		; Move snake.
            	LD (HL),A	; Update.
            	CP $FF		; Reached right limit?
            	JR NZ,L852D	; No, jump.
            	INC HL
            	LD (HL),$01	; Now going left.
            	JR L8533

L852D:      	OR A		; Reached left limit?
            	JR NZ,L8533
            	INC HL
            	LD (HL),$00	; Now going right.
L8533:      	CALL L855B	; Get collision rectangle.
            	CP B		; Less than?
            	RET C		; Yes, return.
            	CP C		; Greater than or equal?
            	RET NC		; Yes, return.
            	LD A,L		; Get pointer.
            	SUB 255 AND L87F3
            	RRCA
            	ADD A,A
            	ADD A,A
            	ADD A,$04	; Convert to sprite used.
            	LD L,A
            	LD H,$1B
            	LD A,L
            	OUT (VDP+1),A
            	LD A,H
            	OUT (VDP+1),A
            	NOP
            	NOP
            	NOP
            	NOP
            	IN A,(VDP)	; Read Y-coordinate.
            	LD B,A
            	LD A,(L8786)	; Y-coordinate of the player.
            	INC A		; Adjust.
            	CP B		; Both are the same?
            	RET NZ		; No, return, no collision.
            	JP L8613	; Yes, player dies.

L855B:      	DEC HL		; Go to X-coordinate.
            	LD A,L		; Force it to be X-coordinate.
            	AND $FE
            	OR $01
            	LD L,A
            	LD B,(HL)	; Get X-coordinate of enemy.
            	JP L8738

            	db $FF  ; $8566

	;
	; Move the player downward.
	;
L8567:      	LD HL,$1B00	; Why on Earth I read VRAM?
            	CALL L85A0	; The coordinates are already in RAM.
            	CALL L85AE	; Convert Y-coordinate to screen row.
            	NOP
            	LD D,A		; Screen column in D.
            	INC HL
            	CALL L85A0	
            	CALL L85FF	; Convert X-coordinate to screen column.
            	RRCA
            	RRCA
            	LD E,A		; Screen column in E.
            	LD A,D		; Wasn't easier LD L,D?
            	LD L,A
            	LD H,$00
            	ADD HL,HL	; x2.
            	ADD HL,HL	; x4.
            	ADD HL,HL	; x8.
            	ADD HL,HL	; x16.
            	ADD HL,HL	; x32.
            	LD D,$00
            	ADD HL,DE	; Add column.
            	LD DE,$3C40	; Offset into screen.
            	ADD HL,DE
            	CALL L85A0	; Read VRAM.
            	LD B,A
            	LD A,(L87FD)
            	ADD A,$03	; Ladder character.
            	CP B		; Is it the same?
            	RET NZ		; No, jump.
            	CALL L85E9	; Animate and get Y-coordinate.
            	ADD A,$02
L859C:      	LD (L8786),A
            	RET

	;
	; Read VRAM.
	;
L85A0:      	LD A,L
            	OUT (VDP+1),A
            	LD A,H
            	OUT (VDP+1),A
            	NOP
            	NOP
            	NOP
            	NOP
            	NOP
            	IN A,(VDP)
            	RET

	;
	; Convert Y-coordinate to screen row.
	;
L85AE:      	INC A
            	AND $F8
            	RRCA
            	RRCA
            	RRCA
            	RET

	;
	; Move the player upward.
	;
L85B5:      	LD A,(L8786)	; Y-coordinate of the player.
            	CALL L85AE	; Convert to screen row.
            	LD D,A
            	INC HL
            	LD A,(L8787)	; X-coordinate of the player.
            	CALL L85FF	; Convert to screen column.
            	RRCA
            	RRCA
            	LD E,A
            	LD A,D		; Wasn't easier LD L,D?
            	LD L,A
            	LD H,$00
            	ADD HL,HL	; x2.
            	ADD HL,HL	; x4.
            	ADD HL,HL	; x8.
            	ADD HL,HL	; x16.
            	ADD HL,HL	; x32.
            	LD D,$00
            	ADD HL,DE	; Add column.
            	LD DE,$3C20	; Offset into screen.
            	ADD HL,DE
            	CALL L85A0	; Read VRAM.
            	LD B,A
            	LD A,(L87FD)
            	CALL L8605	; Validate it is ladder.
            	NOP
            	CALL L85E9	; Animate and get Y-coordinate.
            	SUB $02		; 2 pixels up.
            	JP L859C

	;
	; Animate the player over the ladder.
	;
L85E9:      	LD D,$00	; Not used.
            	ADD HL,DE	; Not used.
            	LD A,(L87FE)	; Sprite frame of the player.
            	LD B,$14	; Switch between $14 and $10 sprite frames.
            	CP $10
            	JR Z,L85F7
            	LD B,$10
L85F7:      	LD A,B		; New sprite frame of the player.
            	LD (L87FE),A
            	LD A,(L8786)	; Get Y-coordinate of the player.
            	RET

	;
	; Convert X-coordinate to column on the screen.
	; Missing two RRCA probably because it is a patch over the code.
	;
L85FF:      	ADD A,$04
            	AND $F8
            	RRCA
            	RET

L8605:      	ADD A,$03	; Get ladder character.
            	CP B		; Same as VRAM read?
            	RET Z		; Yes, return.
            	POP HL
            	LD A,(L8786)
            	INC A
            	AND $F8
            	JP L8631

	;
	; The player dies.
	;
L8613:      	CALL L837A
            	DEC (HL)	; Decrement lives.
            	SCF		; Set carry flag to exit main loop.
				; But it is never used.
                LD SP,L87F0	; Preferred to reset Stack Pointer.
            	JP L8637

L861E:      	LD BC,$1000	; Delay for the game.
            	LD A,(L87FB)	; Lives.
            	ADD A,$30	; Convert to ASCII number.
            	LD HL,$3EB2
            	PUSH AF
            	CALL L0100
            	POP AF
            	OUT (VDP),A	; Write to VRAM.
            	RET

L8631:      	DEC A
            	NOP
            	LD (L8786),A
            	RET

L8637:      	LD A,$0F	; Reset Y-coordinate of the player.
            	LD (L8786),A
            	XOR A		; Reset X-coordinate of the player.
            	LD (L8787),A
            	LD A,(L87FB)
            	CP $FF		; All lives used?
            	JP NZ,L8009	; No, jump.
            	LD HL,$3D4A	; Show Game Over message.
            	CALL L0100
            	CALL L0169
                db "FIN DE JUEGO",0
            	LD B,$05	; Big delay.
L8660:      	PUSH BC
            	LD BC,$0000
L8664:      	DEC BC
            	LD A,B
            	OR C
            	JR NZ,L8664
            	POP BC
            	DJNZ L8660
            	JP L8000	; Restart game.

	;
	; Turn off sound.
	; 
L866F:
	if COLECO
		ld a,$9f
		out (PSG),a
	else
		ld e,$00
		ld a,$08
		call WRTPSG
	endif
            	LD BC,$0000	; Small delay.
L8679:      	DEC BC
            	LD A,B
            	OR C
            	JR NZ,L8679
                LD HL,L87FB	; HL points to number of lives.
            	JR L86F8

            	db $FF  ; $8683
	;
	; Button press to exit level.
	; 
L8684:      	LD A,(L8786)
            	CP $87		; Is it at the bottom floor?
            	RET NZ		; No, return.
            	LD A,(L8787)
            	CP $E8		; Is it inside the drain area?
            	RET C		; No, return.
            	CP $F8
            	RET NC		; No, return.
                LD SP,L87F0	; Restart Stack Pointer.
            	LD A,$0F	; Reset Y-coordinate of the player.
            	LD (L8786),A
            	XOR A		; Reset X-coordinate of the player.
            	LD (L8787),A
            	LD A,(L87FC)
            	CP $05		; Is it at level 5?
            	JP NZ,L8014	; No, return.
            	LD HL,$3D4A	; Show "you won" message.
            	CALL L0100
            	CALL L0169
                db "HAS GANADO !",0
	if COLECO
		ld a,$9f	; Turn off music.
		out (PSG),a
	else
		ld e,$00
		ld a,$08
		call WRTPSG
	endif
            	JP L87B4

L86C5:      	LD A,(DE)
            	CALL L8390
            	INC DE
            	INC HL
            	LD A,(DE)
            	LD B,$18	; Sprite frames for snake going to left.
            	CP $00
            	JR NZ,L86D4
            	LD B,$20	; Sprite frames for snake going to right.
L86D4:      	LD A,(L8788)
            	XOR $01		; Animate snake.
            	LD (L8788),A
            	BIT 0,A		
            	LD A,$00
            	JR Z,L86E4
            	LD A,$04	; Offset for sprite frame.
L86E4:      	ADD A,B
            	CALL L8390	; Save as frame to display.
            	INC HL
            	PUSH HL
            	LD HL,$3900	; Define frame sprites $20 and $24
                LD DE,L8700	; Data for snake going to right.
            	LD BC,$0040	; Length of data.
            	CALL L805D	; Copy to VRAM.
            	POP HL
            	RET

L86F8:      	XOR A
            	LD (L87F9),A
	      	LD (L87FA),A
            	RET

	;
	; Extra sprites for snakes going right.
	;
L8700:
		DB $00,$01,$01,$01,$00,$01,$03,$03
		DB $03,$21,$30,$33,$1b,$1f,$1d,$0c
		DB $00,$b0,$68,$68,$d8,$f0,$78,$ba
		DB $86,$f0,$f8,$78,$78,$f8,$f0,$e0

		DB $00,$00,$00,$00,$00,$01,$01,$41
		DB $40,$60,$60,$70,$33,$37,$3f,$1c
		DB $d8,$b4,$b4,$6c,$f8,$be,$d9,$c0
		DB $f0,$f8,$7c,$3c,$3c,$fc,$f8,$f0

L8738:      	LD A,(L8787)	; Get the player X-coordinate.
            	LD C,B		; Copy B (enemy X-coordinate) into C.
            	DEC B		; B = B - 3
            	DEC B
            	DEC B
            	INC C		; C = C + 4
            	INC C
            	INC C
            	INC C
            	RET

	;
	; Notes to play for background song.
	;
L8744:          db $01,$02,$03,$04  ; $8744
            	db $05,$04,$03,$02  ; $8748
            	db $01,$02,$03,$04  ; $874C
            	db $05,$04,$03,$02  ; $8750
            	db $06,$04,$07,$08  ; $8754
            	db $09,$08,$07,$04  ; $8758
            	db $06,$04,$07,$08  ; $875C
            	db $09,$08,$07,$04  ; $8760
            	db $03,$0C,$08,$0A  ; $8764
            	db $0B,$0A,$08,$0C  ; $8768
            	db $06,$04,$07,$08  ; $876C
            	db $09,$08,$07,$04  ; $8770

L8774:      	LD BC,$0000	; Delay after sound effect.
L8777:      	DEC BC
            	LD A,B
            	OR C
            	JR NZ,L8777
            	JP L866F

                db $FF
		db $FF		; $8789  

L878A:      	LD B,$05	; Big delay.
L878C:      	PUSH BC
            	LD BC,$0000
L8790:      	DEC BC
            	LD A,B
            	OR C
            	JR NZ,L8790
            	POP BC
            	DJNZ L878C
                LD SP,L87F0	; Reset Stack Pointer.
            	LD A,$0F	; Reset Y-coordinate for the player.
            	LD (L8786),A
            	XOR A		; Reset X-coordinate for the player.
            	LD (L8787),A
            	LD A,$01	; Restart at level 1.
            	LD (L87FC),A
                LD HL,L87F9
            	LD (HL),$00
            	INC HL
            	LD (HL),$00
            	JP L8009

L87B4:      	
            	JP L878A

L87F0:          equ RAM_BASE+$0400	; Stack base.

	org RAM_BASE

L8780:          rb 2		; Random generator 1.
L8782:          rb 2		; Random generator 2.
L8784:          rb 2		; Random generator 3.
L8786:          rb 1		; Y-coordinate for the player.
L8787:          rb 1		; X-coordinate for the player.
L8788:          rb 1		; Animation bit for snakes.

		rb 10
	; This should be an odd address (calculated to be $7013 or $e013)
L87F3:          rb 1		; X-coordinate of enemy 1.
L87F4:          rb 1		; X-direction of enemy 1.
L87F5:          rb 1		; X-coordinate of enemy 2.
L87F6:          rb 1		; X-direction of enemy 2.
L87F7:          rb 1		; X-coordinate of enemy 3.
L87F8:          rb 1		; X-direction of enemy 3.
L87F9:          rb 1		; Note index for music player.
L87FA:          rb 1		; Tick counter for music player.
L87FB:          rb 1		; Current lives.
L87FC:          rb 1		; Current level. 
L87FD:          rb 1		; Base character for drawing.
L87FE:          rb 1		; Sprite frame for the player.
L87FF:          rb 1		; Not used, yet initialized.
